#!/bin/bash
# Copyright(c) 2017 NEC Corporation.

#DEBUG=ON
DEBUG=OFF
COB_CMD="cobbler"
CMD_LINE="${COB_CMD} system add "

usage()
{
    echo "usage: cobimport.sh --hostlist=HPATH --profile=string"
    echo "       --interface=string [--static=1] ..."
}

HOSTLIST=""
PROFILE=""
INTERFACE=""
STATIC=""
OTHEROPT=()

# Parse options
while [ -n "$1" ]
do
opt=$1
    case "${opt}" in
        # Host list
        '--hostlist' )
            if [[ -z "$2" ]] || [[ "$2" =~ ^- ]]
            then
                usage
                exit 1
            fi
            HOSTLIST=$2
            shift 2
            ;;
        '--hostlist='* )
            [[ $1 =~ ^--hostlist=(.+)$ ]]
            HOSTLIST=${BASH_REMATCH[1]}
            shift
            ;;
        # Interface
        '--interface' )
            if [[ -z "$2" ]] || [[ "$2" =~ ^- ]]
            then
                usage
                exit 1
            fi
            INTERFACE=$2
            shift 2
            ;;
        '--interface='* )
            [[ $1 =~ ^--interface=(.+)$ ]]
            INTERFACE=${BASH_REMATCH[1]}
            shift
            ;;
        # Profile
        '--profile' )
            if [[ -z "$2" ]] || [[ "$2" =~ ^- ]]
            then
                usage
                exit 1
            fi
            PROFILE=$2
            shift 2
            ;;
        '--profile='* )
            [[ $1 =~ ^--profile=(.+)$ ]]
            PROFILE=${BASH_REMATCH[1]}
            shift
            ;;
        # Static
        '--static' )
            if [[ -z "$2" ]] || [[ "$2" =~ ^- ]]
            then
                usage
                exit 1
            fi
            STATIC=$2
            shift 2
            ;;
        '--static='* )
            [[ $1 =~ ^--static=(.+)$ ]]
            STATIC=${BASH_REMATCH[1]}
            if [[ "${STATIC}" = "" ]]
            then
                usage
                exit 1
            fi
            shift
            ;;
        # Ignore name option
        '--name' )
            if [[ -n "$2" ]] && [[ ! "$2" =~ ^- ]]
            then
                shift
            fi
            shift
            ;;
        '--name='* )
            shift
            ;;
        # Ignore hostname option
        '--hostname' )
            if [[ -n "$2" ]] && [[ ! "$2" =~ ^- ]]
            then
                shift
            fi
            shift
            ;;
        '--hostname='* )
            shift
            ;;
        # Ignore ip option
        '--ip-address' )
            if [[ -n "$2" ]] && [[ ! "$2" =~ ^- ]]
            then
                shift
            fi
            shift
            ;;
        '--ip-address='* )
            shift
            ;;
        # Ignore mac option
        '--mac' )
            if [[ -n "$2" ]] && [[ ! "$2" =~ ^- ]]
            then
                shift
            fi
            shift
            ;;
        '--mac='* )
            shift
            ;;
        # Ignore netmask option
        '--netmask' )
            if [[ -n "$2" ]] && [[ ! "$2" =~ ^- ]]
            then
                shift
            fi
            shift
            ;;
        '--netmask='* )
            shift
            ;;
        # Ignore gateway option
        '--gateway' )
            if [[ -n "$2" ]] && [[ ! "$2" =~ ^- ]]
            then
                shift
            fi
            shift
            ;;
        '--gateway='* )
            shift
            ;;
        # Help
        '-h' | '--help' )
            usage
            exit 0
            ;;
        * )
            OTHEROPT+=( "${opt}" )
            shift
            ;;
    esac
done

# Option check
if [ "${HOSTLIST}" = "" ] || [ "${INTERFACE}" = "" ] || [ "${PROFILE}" = "" ]
then
    usage
    exit 1
fi

# Hostlist check
if [ ! -r ${HOSTLIST} ]
then
    echo "can not read hostlist file."
    exit 1
fi

RC=0
while read line
do
    eval set -- "${line}"
    # Check if gateway was omitted
    if [ "$5" = "" ]
    then
        CMD="${CMD_LINE} --name=$1 --hostname=$1 --mac=$2 --ip-address=$3 --netmask=$4"
    else
        CMD="${CMD_LINE} --name=$1 --hostname=$1 --mac=$2 --ip-address=$3 --netmask=$4 --gateway=$5"
    fi
    # Check if --static option was omitted
    if [ "${STATIC}" = "" ]
    then
        CMD="${CMD} --profile=${PROFILE} --interface=${INTERFACE} ${OTHEROPT[@]}"
    else
        CMD="${CMD} --profile=${PROFILE} --interface=${INTERFACE} --static=${STATIC} ${OTHEROPT[@]}"
    fi
    if [ "$DEBUG" = "ON" ]
    then
        echo ${CMD}
    else
        ${CMD}
        RET=$?
        if [ ${RET} != 0 ]
        then
            RC=${RET}
        fi
    fi
done < ${HOSTLIST}

exit ${RC}
