/*
** Zabbix
** Copyright (C) 2001-2015 Zabbix SIA
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/
#ifndef __VE_ITEM_H__
#define __VE_ITEM_H__
#include <linux/limits.h>

#ifdef _SIOX_
struct	vh_info
{
	char	vh_name[16];
	long	ve_num;
};

typedef	struct	vh_info	vh_info_t;
#endif

#define	VE_MAX	8
#define	VE_CMAX	16
#define VE_MODEL_MAX 32

struct	ve_path
{
	char	slot[8];
	int	lpcn[VE_CMAX];
	char	path[PATH_MAX];
    char VE_model[VE_MODEL_MAX];
};

typedef	struct	ve_path	ve_path_t;

typedef struct
{
	char		*key;
	char		*f_name;
	int		r_type;
}
VAL_KFT_t;

#define AR_BITCNT	0x03
#define AR_DOUBLE3	0x0e
#define AR_DOUBLE6	0x1a
#define AR_UINT64K	0x0d
#define AR_UINT64K3	0x0b
#define AR_UINT64Ki	0x0f
#define AR_UINT64M	0x11
#define AR_UINT64Mi	0x12
#define AR_UINT64G	0x15
#define AR_STATE	0x0c
#define AR_VERSION  0x1d
#define AR_ASCII    0x2d

#endif
